'
' This class impelments StreamingSensor operations for sensors made
' by Hawk.
'
Public Class HawkStreamingSensor
    Inherits HawkSimpleSensor
    Implements StreamingSensorImpl

    Private ssl As StreamingSensorListener
    Private freq As Integer

    '
    ' Streaming sensors produce a stream of measurement values.  The
    ' stream of values is produced with a frequency no greater than
    ' the given number of times per minute.
    '
    Public WriteOnly Property SamplingFrequency() As Integer _
     Implements StreamingSensorImpl.SamplingFrequency
        Set(ByVal value As Integer)
            freq = Value
        End Set
    End Property ' SamplingFrequency

    '
    ' This property is set by an object than represents the
    ' streaming sensor abstraction so that this object can perform a
    ' call-back to that object to deliver measurement values to it.
    '
    Public WriteOnly Property StreamingSensorListener() _
     As StreamingSensorListener _
     Implements StreamingSensorImpl.StreamingSensorListener
        Set(ByVal value As StreamingSensorListener)
            ssl = CType(Value, StreamingSensorListener)
        End Set
    End Property
End Class 'HawkStreamingSensor 